/*
 * data.c -- Data type clear, default, and free routines
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/data.c,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 23:28 Jul 21 2000 kivinen
 *	  Last Modification : 00:51 Jan  8 2004 kivinen
 *	  Last check in     : $Date: 2003/08/18 20:09:53 $
 *	  Revision number   : $Revision: 1.4 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.20
 *	  Edit time	    : 3 min
 *
 *	  Description       : Data type clear, default, and free routines
 *
 *	  $Log: data.c,v $
 *	  Revision 1.4  2003/08/18 20:09:53  kivinen
 *	  	Added support for GPS V. Fixed packet size and actual size
 *	  	comparisions.
 *
 *	  Revision 1.3  2001/08/23 15:42:08  kivinen
 *	  	Added initialization of extra field in track and almanac
 *	  	records. Fixed clearing of space padded fields.
 *
 *	  Revision 1.2  2000/08/05 00:44:46  kivinen
 *	  	Removed warnings.
 *
 *	  Revision 1.1  2000/07/21 22:16:36  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#include "tgps.h"
#include "data.h"

/* Clear waypoint structure */
void tgps_clear_waypoint(TgpsWaypoint w)
{
  memset(w->ident, ' ', sizeof(w->ident));
  w->ident[sizeof(w->ident) - 1] = '\0';
  w->lat = -2147483647L;
  w->lon = -2147483647L;
  w->unused_creation_time = -1;
  memset(w->comment, ' ', sizeof(w->comment));
  w->comment[sizeof(w->comment) - 1] = '\0';
  w->smbl_type = TGPS_INVALID_CHAR;
  w->smbl = TGPS_INVALID_CHAR;
  w->smbl16 = TGPS_INVALID_INT;
  w->display = TGPS_INVALID_CHAR;
  w->color = TGPS_INVALID_CHAR;
  w->proximity = TGPS_INVALID_FLOAT;
  w->class = TGPS_INVALID_CHAR;
  w->attribute = TGPS_INVALID_CHAR;
  memset(w->subclass, 0, sizeof(w->subclass));
  w->wpt_ident = NULL;
  w->lnk_ident = NULL;
  memset(w->cc, ' ', sizeof(w->cc));
  w->cc[sizeof(w->cc) - 1] = '\0';
  memset(w->city, ' ', sizeof(w->city));
  w->city[sizeof(w->city) - 1] = '\0';
  memset(w->state, ' ', sizeof(w->state));
  w->state[sizeof(w->state) - 1] = '\0';
  memset(w->name, ' ', sizeof(w->name));
  w->name[sizeof(w->name) - 1] = '\0';
  w->alt = TGPS_INVALID_INT;
  w->altf = TGPS_INVALID_FLOAT;
  w->ete = 0xffffffff;
  w->dpth = TGPS_INVALID_FLOAT;
  w->idx = TGPS_INVALID_CHAR;
  w->comment_var = NULL;
  w->facility_var = NULL;
  w->city_var = NULL;
  w->addr_var = NULL;
  w->cross_road_var = NULL;
}

/* Set values to defaults in waypoint structure */
void tgps_defaults_waypoint(TgpsWaypoint w)
{
  if (w->unused_creation_time == -1)
    w->unused_creation_time = 0;
  if (w->smbl_type == TGPS_INVALID_CHAR)
    w->smbl_type = 0;
  if (w->smbl == TGPS_INVALID_CHAR)
    w->smbl = 0;
  if (w->smbl16 == TGPS_INVALID_INT)
    w->smbl16 = 0;
  if (w->display == TGPS_INVALID_CHAR)
    w->display = 0;
  if (w->color == TGPS_INVALID_CHAR)
    w->color = 0;
  if (w->proximity == TGPS_INVALID_FLOAT)
    w->proximity = 0;
  if (w->class == TGPS_INVALID_CHAR)
    w->class = 0;
  if (w->attribute == TGPS_INVALID_CHAR)
    w->attribute = 0;
  if (w->alt == TGPS_INVALID_INT)
    w->alt = 0;
  if (w->altf == TGPS_INVALID_FLOAT)
    w->altf = 0;
  if (w->dpth == TGPS_INVALID_FLOAT)
    w->dpth = 0;
  if (w->idx == TGPS_INVALID_CHAR)
    w->idx = 0;
}

/* Free waypoint structure */
void tgps_free_waypoint(TgpsWaypoint w)
{
  free(w->comment_var);
  free(w->facility_var);
  free(w->city_var);
  free(w->addr_var);
  free(w->cross_road_var);
  free(w->wpt_ident);
  free(w->lnk_ident);
}

/* Clear route header structure */
void tgps_clear_route_header(TgpsRouteHeader r)
{
  r->number = TGPS_INVALID_CHAR;
  memset(r->comment, ' ', sizeof(r->comment));
  r->comment[sizeof(r->comment) - 1] = '\0';
  r->rte_ident = NULL;
}

/* Set values to defaults in route header structure */
void tgps_defaults_route_header(TgpsRouteHeader r)
{
  if (r->number == TGPS_INVALID_CHAR)
    r->number = 0;
}

/* Free route header structure */
void tgps_free_route_header(TgpsRouteHeader r)
{
  free(r->rte_ident);
}

/* Clear route link structure */
void tgps_clear_route_link(TgpsRouteLnk r)
{
  r->class = TGPS_INVALID_CHAR;
  memset(r->subclass, ' ', sizeof(r->subclass));
  r->ident = NULL;
}

/* Set values to defaults in route link structure */
void tgps_defaults_route_link(TgpsRouteLnk r)
{
  if (r->class == TGPS_INVALID_CHAR)
    r->class = 0;
  if (memcmp(r->subclass, "                  ", sizeof(r->subclass)) == 0)
    {
      memset(r->subclass, 0, 6);
      memset(r->subclass + 6, 0xff, 12);
    }
}

/* Free route link structure */
void tgps_free_route_link(TgpsRouteLnk r)
{
  free(r->ident);
}

/* Clear almanac header structure */
void tgps_clear_almanac(TgpsAlmanac a)
{
  a->svid = TGPS_INVALID_CHAR;
  a->wn = TGPS_INVALID_INT;
  a->toa = TGPS_INVALID_FLOAT;
  a->af0 = TGPS_INVALID_FLOAT;
  a->af1 = TGPS_INVALID_FLOAT;
  a->e = TGPS_INVALID_FLOAT;
  a->sqrta = TGPS_INVALID_FLOAT;
  a->m0 = TGPS_INVALID_FLOAT;
  a->w = TGPS_INVALID_FLOAT;
  a->omg0 = TGPS_INVALID_FLOAT;
  a->odot = TGPS_INVALID_FLOAT;
  a->i = TGPS_INVALID_FLOAT;
  a->hlth = TGPS_INVALID_CHAR;
  memset(a->extra, 0, sizeof(a->extra));
}

/* Free route header structure */
void tgps_free_almanac(TgpsAlmanac a)
{
  return;
}

/* Clear track structure */
void tgps_clear_track(TgpsTrack t)
{
  t->lat = TGPS_INVALID_LONG;
  t->lon = TGPS_INVALID_LONG;
  t->time = 0;
  t->new_track = 0;
  t->alt = TGPS_INVALID_FLOAT;
  t->dpth = TGPS_INVALID_FLOAT;
  memset(t->extra, 0, sizeof(t->extra));
}

/* Set values to defaults in track structure */
void tgps_defaults_track(TgpsTrack t)
{
  if (t->alt > TGPS_INVALID_FLOAT_TEST)
    t->alt = 0;
  if (t->dpth > TGPS_INVALID_FLOAT_TEST)
    t->dpth = 0;
}

/* Clear track header structure */
void tgps_clear_track_header(TgpsTrackHeader t)
{
  t->display = TGPS_INVALID_CHAR;
  t->color = TGPS_INVALID_CHAR;
  t->line_width = 0;
  t->fill = 0;
  t->ident = NULL;
}

/* Set valus to defaults in track header structure */
void tgps_defaults_track_header(TgpsTrackHeader t)
{
  if (t->display == TGPS_INVALID_CHAR)
    t->display = 0;
  if (t->color == TGPS_INVALID_CHAR)
    t->color = 0;
}

/* Free track header structure */
void tgps_free_track_header(TgpsTrackHeader t)
{
  free(t->ident);
}

