/*
 * display.c -- GPS protocol display code.
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/display.h,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 19:16 Aug  4 2000 kivinen
 *	  Last Modification : 19:18 Aug  4 2000 kivinen
 *	  Last check in     : $Date: 2000/08/05 00:44:27 $
 *	  Revision number   : $Revision: 1.1 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.6
 *	  Edit time	    : 2 min
 *
 *	  Description       : GPS protocol display code
 *
 *	  $Log: display.h,v $
 *	  Revision 1.1  2000/08/05 00:44:27  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#ifndef TGPS_DISPLAY_H
#define TGPS_DISPLAY_H

#include "tgps.h"

/* Print position */
void tgps_print_pos(Tgps conn, double d);

/* Print waypoint structure */
void tgps_print_waypoint(Tgps conn, TgpsWaypoint w);

/* Print route header structure */
void tgps_print_route_header(Tgps conn, TgpsRouteHeader r);

/* Print route link structure */
void tgps_print_route_link(Tgps conn, TgpsRouteLnk r);

/* Print track point structure */
void tgps_print_track(Tgps conn, TgpsTrack t);

/* Print track header structure */
void tgps_print_track_header(Tgps conn, TgpsTrackHeader t);

/* Print almanac structure */
void tgps_print_almanac(Tgps conn, TgpsAlmanac a);

/* Print time structure */
void tgps_print_time(Tgps conn, TgpsTime t);

/* Print position structure */
void tgps_print_position(Tgps conn, TgpsPosition p);

/* Print pvt structure */
void tgps_print_pvt(Tgps conn, TgpsPvt p);

/* Print header */
void tgps_print_header(Tgps conn);

#endif /* TGPS_DISPLAY_H */
