/*
 * enum.c -- enumeration tables
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/enum.c,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 02:11 May 22 2000 kivinen
 *	  Last Modification : 19:55 Aug  4 2000 kivinen
 *	  Last check in     : $Date: 2000/08/05 00:45:01 $
 *	  Revision number   : $Revision: 1.2 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.7
 *	  Edit time	    : 1 min
 *
 *	  Description       : GPS garmin tables.
 *
 *	  $Log: enum.c,v $
 *	  Revision 1.2  2000/08/05 00:45:01  kivinen
 *	  	Removed warnings.
 *
 *	  Revision 1.1  2000/07/06 23:06:20  kivinen
 *	  	Added initial upload support.
 *
 *	  $EndLog$
 */

#include <stdio.h>
#include <strings.h>
#include "enum.h"

/* Convert string to number and return the number or -1 if name not found */
int tgps_string_to_number(TgpsEnumTable table, int cnt, const char *name)
{
  int i;

  for(i = 0; i < cnt; i++)
    {
      if (strcasecmp(table[i].name, name) == 0)
	return table[i].number;
    }
  return -1;
}

/* Convert number to string and return constant string. If number not found,
   return NULL */
const char *tgps_number_to_string(TgpsEnumTable table, int cnt, int number)
{
  int i;

  for(i = 0; i < cnt; i++)
    {
      if (table[i].number == number)
	return table[i].name;
    }
  return NULL;
}
