/*
 * enum.h -- enumeration tables
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/enum.h,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 02:10 May 22 2000 kivinen
 *	  Last Modification : 02:10 May 22 2000 kivinen
 *	  Last check in     : $Date: 2000/07/06 23:06:25 $
 *	  Revision number   : $Revision: 1.1 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.2
 *	  Edit time	    : 2 min
 *
 *	  Description       : GPS garmin tables.
 *
 *	  $Log: enum.h,v $
 *	  Revision 1.1  2000/07/06 23:06:25  kivinen
 *	  	Added initial upload support.
 *
 *	  $EndLog$
 */

#ifndef ENUM_H
#define ENUM_H

/* Enum tables */
typedef struct TgpsEnumTableRec {
  const char *name;
  int number;
} *TgpsEnumTable;

/* Convert string to number and return the number or -1 if name not found */
int tgps_string_to_number(TgpsEnumTable table, int cnt, const char *name);

/* Convert number to string and return constant string. If number not found,
   return NULL */
const char *tgps_number_to_string(TgpsEnumTable table, int cnt, int number);

#endif /* ENUM_H */
