/*
 * time.c -- GPS protocol time handling.
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/time.c,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 21:36 Apr 24 2000 kivinen
 *	  Last Modification : 14:49 Aug  9 2003 kivinen
 *	  Last check in     : $Date: 2003/08/18 20:08:11 $
 *	  Revision number   : $Revision: 1.4 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.64
 *	  Edit time	    : 16 min
 *
 *	  Description       : GPS protocol time handling
 *
 *	  $Log: time.c,v $
 *	  Revision 1.4  2003/08/18 20:08:11  kivinen
 *	  	Added support for GPS V. Fixed packet size and actual size
 *	  	comparisions.
 *
 *	  Revision 1.3  2000/08/05 00:43:37  kivinen
 *	  	Updated to new interface.
 *
 *	  Revision 1.2  2000/07/06 23:07:33  kivinen
 *	  	Added initial upload support.
 *
 *	  Revision 1.1  2000/04/29 16:40:54  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#include "tgps.h"
#include "data.h"
#include "packet.h"

/* Process time packet */
int tgps_time_data_in(Tgps conn, TgpsPacket packet, TgpsTime t)
{
  if (tgps_is_supported(conn, 'D', 600) || packet->data_len == 10)
    {
      size_t size;

      size = tgps_decode(packet->data, packet->data_len,
			 TGPS_FORMAT_BYTE, NULL, TGPS_FORMAT_BYTE, NULL,
			 TGPS_FORMAT_BYTE, &t->month,
			 TGPS_FORMAT_BYTE, &t->day,
			 TGPS_FORMAT_WORD, &t->year,
			 TGPS_FORMAT_INT, &t->hour,
			 TGPS_FORMAT_BYTE, &t->minute,
			 TGPS_FORMAT_BYTE, &t->second,
			 TGPS_FORMAT_END);
      if (size == packet->data_len)
	{
	  conn->packet_count--;
	  if (conn->packet_count == 0)
	    conn->xfer_done = 1;
	  return 1;
	}
      if (size < packet->data_len)
	{
	  conn->packet_count--;
	  if (conn->packet_count == 0)
	    conn->xfer_done = 1;
	  fprintf(stderr, "Warning, extra junk after packet\n");
	  return 1;
	}
      return 0;
    }
  else
    {
      fprintf(stderr, "Unknown time data\n");
      return 0;
    }
}

/* Send time packet */
TgpsPacket tgps_time_data_out(Tgps conn, TgpsTime t)
{
  TgpsPacket p = NULL;
  size_t size;

  if (tgps_is_supported(conn, 'D', 600))
    {
      p = tgps_get_packet(conn, 255);
      size = tgps_encode(p->data, 255,
			 TGPS_FORMAT_BYTE, TGPS_PID_DATE_TIME_DATA(conn),
			 TGPS_FORMAT_LEN,
			 TGPS_FORMAT_BYTE, t->month,
			 TGPS_FORMAT_BYTE, t->day,
			 TGPS_FORMAT_WORD, t->year,
			 TGPS_FORMAT_INT, t->hour,
			 TGPS_FORMAT_BYTE, t->minute,
			 TGPS_FORMAT_BYTE, t->second,
			 TGPS_FORMAT_END);
      if (size <= 0)
	{
	  fprintf(stderr, "Internal error, packet buffer too "
		  "short for packet\n");
	  exit(1);
	}
      else
	{
	  p->data_len = size;
	}
    }
  else
    {
      fprintf(stderr, "Unknown time protocol format\n");
    }
  return p;
}
